﻿using System;

namespace DocumentProcessing
{
    class ProductionDeptTool1
    {
        public void Subscribe(DocumentProcessor processor)
        {
            processor.Processing += processor_Processing;
            processor.Processed += processor_Processed;
        }
        public void Unsubscribe(DocumentProcessor processor)
        {
            processor.Processing -= processor_Processing;
            processor.Processed -= processor_Processed;
        }
        void processor_Processing(object sender, ProcessCancelEventArgs e)
        {
            Console.WriteLine("Narzędzie 1. - zarejestrowano przetwarzanie, wykonanie nie zostało anulowane.");
        }
        void processor_Processed(object sender, EventArgs e)
        {
            Console.WriteLine("Narzędzie 1. - zarejestrowano zakończenie przetwarzania.");
        }
    }
    class ProductionDeptTool2
    {
        public void Subscribe(DocumentProcessor processor)
        {
            processor.Processing += (sender, e) =>
            {
                Console.WriteLine("Narzędzie 2. - zarejestrowano przetwarzanie i anulowano je.");
                if (e.Document.Text.Contains("dokument"))
                {
                    e.Cancel = true;
                }
            };
            processor.Processed += (sender, e) =>
            Console.WriteLine("Narzędzie 2. - zarejestrowano zakończenie przetwarzania.");
        }
    }
}
